/* Adobe.Gamer.js */

/* ship week findings:	
--	behavior creation: rehearsal vs. recording
--	behavior creation: need easy examples of using different input methods (mouse/keybd/etc) to control different things (params/transforms); docs important
--	behavior creation: rescan behaviors + refresh scene

--	cycle layers: reverse order (preferred when creating sequences in PS, which pastes on top)

--	bugs:
	--	transform reset
	--	rescan behaviors doesn't pick up new defaults?
*/
define(["lib/Zoot", "lib/dev", "lib/tasks"], 
function(Z, dev, tasks) {
	"use strict";
				 
	function setupTriggerableLayer (args, paramID)
	{
		var bHideSiblings = true;

		var aLayers = args.getStaticParam(paramID);

		aLayers.forEach(function (lay) {
			lay.setTriggerable(bHideSiblings);
		});
	}
	  
	function defineLayer (id, dx, dy, uiName, match, uiToolTip0)
	{
		var def = { 
				id: id, type: "layer", uiName: uiName,
				dephault: { match: "//" + match },
				customData: { dx: dx, dy: dy }	// TODO: make this official behavior-specific field
		};
		
		if (uiToolTip0) {
			def.uiToolTip = uiToolTip0;
		}
		
		return def;
	}
	
	var aLayerTags = [
		{
			id: "Adobe.MotionTrigger.AtRest",
			artMatches: ["at rest"],	// TODO: add language synonyms
			uiName: "$$$/animal/Behavior/MotionTrigger/UIName/AtRest=At Rest",
			tagType: "layertag",
			uiGroups: [{id: "Adobe.TagGroup.MotionTrigger", subSort: 0}]
		},					
		{
			id: "Adobe.MotionTrigger.MovingLeft",
			artMatches: ["moving left"],
			uiName: "$$$/animal/Behavior/MotionTrigger/UIName/MovingLeft=Moving Left",
			tagType: "layertag",
			uiGroups: [{id: "Adobe.TagGroup.MotionTrigger", subSort: 0}]
		},					
		{
			id: "Adobe.MotionTrigger.MovingRight",
			artMatches: ["moving right"],
			uiName: "$$$/animal/Behavior/MotionTrigger/UIName/MovingRight=Moving Right",
			tagType: "layertag",
			uiGroups: [{id: "Adobe.TagGroup.MotionTrigger", subSort: 0}]
		},					
		{
			id: "Adobe.MotionTrigger.MovingUp",
			artMatches: ["moving up"],
			uiName: "$$$/animal/Behavior/MotionTrigger/UIName/MovingUp=Moving Up",
			tagType: "layertag",
			uiGroups: [{id: "Adobe.TagGroup.MotionTrigger", subSort: 0}]
		},					
		{
			id: "Adobe.MotionTrigger.MovingDown",
			artMatches: ["moving down"],
			uiName: "$$$/animal/Behavior/MotionTrigger/UIName/MovingDown=Moving Down",
			tagType: "layertag",
			uiGroups: [{id: "Adobe.TagGroup.MotionTrigger", subSort: 0}]
		},
		{
			id: "Adobe.MotionTrigger.InTransition",
			artMatches: ["in transition"],
			uiName: "$$$/animal/Behavior/MotionTrigger/UIName/InTransition=In Transition",
			tagType: "layertag",
			uiGroups: [{id: "Adobe.TagGroup.MotionTrigger", subSort: 0}]
		}
	];

	
	var aLayerParamDefs = [
		defineLayer("atRest", 0, 0,
					"$$$/animal/Behavior/MotionTrigger/LayerParam/AtRest=At Rest",
					 "Adobe.MotionTrigger.AtRest",
					 "$$$/private/Behavior/Gamer/LayerParam/AtRest/ToolTip=Layers that will be triggered when the puppet isn^}t moving"),
		defineLayer("movingLeft", -1, 0,
					"$$$/animal/Behavior/MotionTrigger/LayerParam/MovingLeft=Moving Left",
					 "Adobe.MotionTrigger.MovingLeft",
					 "$$$/private/Behavior/Gamer/LayerParam/MovingLeft/ToolTip=Layers that will be triggered when the puppet is moving to the left"),
		defineLayer("movingRight", +1, 0,
					"$$$/animal/Behavior/MotionTrigger/LayerParam/MovingRight=Moving Right",
					 "Adobe.MotionTrigger.MovingRight",
					 "$$$/private/Behavior/Gamer/LayerParam/MovingRight/ToolTip=Layers that will be triggered when the puppet is moving to the right"),
		defineLayer("movingUp", 0, -1,
					"$$$/animal/Behavior/MotionTrigger/LayerParam/MovingUp=Moving Up",
					 "Adobe.MotionTrigger.MovingUp",
					 "$$$/private/Behavior/Gamer/LayerParam/MovingUp/ToolTip=Layers that will be triggered when the puppet is moving up"),
		defineLayer("movingDown", 0, +1,
					"$$$/animal/Behavior/MotionTrigger/LayerParam/MovingDown=Moving Down",
					 "Adobe.MotionTrigger.MovingDown",
					 "$$$/private/Behavior/Gamer/LayerParam/MovingDown/ToolTip=Layers that will be triggered when the puppet is moving down"),
		defineLayer("inTransition", 0, 0,
					"$$$/private/Behavior/Gamer/LayerParam/InTransition=In Transition",
					 "Adobe.MotionTrigger.InTransition",
					 "$$$/private/Behavior/Gamer/LayerParam/InTransition/ToolTip=Layers that will be triggered when the puppet switches from moving in one direction to another direction"),
    ];

    var wKeyCode = Z.keyCodes.getKeyGraphId("W"),
        aKeyCode = Z.keyCodes.getKeyGraphId("A"),
		sKeyCode = Z.keyCodes.getKeyGraphId("S"),
		dKeyCode = Z.keyCodes.getKeyGraphId("D"),
		rKeyCode = Z.keyCodes.getKeyGraphId("R");

	return {
		about:        "$$$/private/Behavior/Gamer/About=Gamer, (c) 2016 Adobe Systems Incorporated. All rights reserved.",
		description:  "$$$/private/Behavior/Gamer/Desc=Moves a puppet using gaming-style WASD keybaord controls, and pans a background in the opposite direction",
		uiName:       "$$$/private/Behavior/Gamer/UIName=Gamer",
		hideInBehaviorList: true,
		defaultArmedForRecordOn: true,

		defineTags: function () {
			return {aTags: aLayerTags};
		},
		
		defineParams : function () {
			var aParams = [];
			
			aLayerParamDefs.forEach(function (def) {
				aParams.push(def);
			});

			aParams.push({
                id: "KeyboardInput", type: "eventGraph", 
                uiName: "$$$/private/Behavior/Gamer/Parameter/KeyboardInput=Keyboard Input", inputKeysArray: ["Keyboard/"],
                uiToolTip: "$$$/private/Behavior/Gamer/Parameter/KeyboardInput/tooltip=Keyboard input used to move artwork", defaultArmedForRecordOn: true
            });
			
			aParams.push({
                id: "reversePanning", type: "checkbox", 
                uiName: "$$$/private/Behavior/Gamer/Parameter/ReversePanning=Reverse Panning",
                uiToolTip: "$$$/private/Behavior/Gamer/Parameter/ReversePanning/tooltip=TBD", 
                dephault: false 
            });
			
			aParams.push({
                id: "panningOffsetX", type: "slider",
                uiName: "$$$/private/Behavior/Gamer/Param/OffsetX=Panning Horiz Distance",
                uiUnits: "$$$/private/Behavior/Gamer/Param/OffsetX/units=px",
                min: 0, max: 1000, dephault: 20,
                uiToolTip: "$$$/private/Behavior/Gamer/Param/OffsetX/ToolTip=TBD"
            });
			
			aParams.push({
                id: "panningOffsetY", type: "slider",
                uiName: "$$$/private/Behavior/Gamer/Param/OffsetY=Panning Vert Distance",
                uiUnits: "$$$/private/Behavior/Gamer/Param/OffsetY/units=px",
                min: 0, max: 1000, dephault: 10,
                uiToolTip: "$$$/private/Behavior/Gamer/Param/OffsetY/ToolTip=TBD"
            });
			
			return aParams;
		},
		
		onCreateBackStageBehavior : function (/*self*/) {
			return { order: 1.0, importance : 0.0 };
		},

		onCreateStageBehavior : function (self, args) {
			aLayerParamDefs.forEach(function (def) {
				setupTriggerableLayer(args, def.id);
			});
			var handle = args.stageLayer.privateLayer.getHandleTreeRoot();
			self.lastTransform = tasks.handle.getFrame(handle);
			self.lastTriggered = "atRest";
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage
			var layerToShow = "atRest",
                privateLayer = args.stageLayer.privateLayer,
				handle = privateLayer.getHandleTreeRoot(),
                handleTransform = self.lastTransform,
				wDown = args.getParamEventValue("KeyboardInput", wKeyCode) || 0,
                aDown = args.getParamEventValue("KeyboardInput", aKeyCode) || 0,
				sDown = args.getParamEventValue("KeyboardInput", sKeyCode) || 0,
				dDown = args.getParamEventValue("KeyboardInput", dKeyCode) || 0,
                rDown = args.getParamEventValue("KeyboardInput", rKeyCode) || 0,
                reversePan = args.getParam("reversePanning"),
                offsetX = args.getParam("panningOffsetX"),
                offsetY = args.getParam("panningOffsetY");
            
            if (reversePan) {
                offsetX = rDown ? 0 : -offsetX;
                offsetY = rDown ? 0 : -offsetY;
            }
            else {
                offsetX = rDown ? offsetX : 0;
                offsetY = rDown ? offsetY : 0;
            }
            //console.logToUser("reversePan=" + reversePan + ", rDown=" + rDown + ", offsetX=" + offsetX + ", offsetY=" + offsetY);
            layerToShow = "atRest"; //self.lastTriggered;

            if (1) {
                if (wDown) {
                    args.setEventGraphParamRecordingValid("KeyboardInput");
                    layerToShow = "movingUp";

                    handleTransform[7] -= offsetY;    // pull vertical offset component from matrix
                }
                if (aDown) {
                    args.setEventGraphParamRecordingValid("KeyboardInput");
                    layerToShow = "movingLeft";

                    handleTransform[6] -= offsetX;    // pull horizontal offset component from matrix
                }
                if (sDown) {
                    args.setEventGraphParamRecordingValid("KeyboardInput");
                    layerToShow = "movingDown";

                    handleTransform[7] += offsetY;    // pull vertical offset component from matrix
                }
                if (dDown) {
                    args.setEventGraphParamRecordingValid("KeyboardInput");
                    layerToShow = "movingRight";

                    handleTransform[6] += offsetX;    // pull horizontal offset component from matrix
                }
				tasks.handle.setFrame(handle, handleTransform, tasks.dofs.type.kAffine);

                self.lastTransform = handleTransform;   
            }
            
			var aLayers = args.getParam(layerToShow);
			aLayers.forEach(function (lay) {
				lay.trigger(); // will show this one and hide its untriggered siblings
			});
			
			if (layerToShow === self.lastTriggered) {
				self.repeatedFramesShown++;
			} else {
				self.repeatedFramesShown = 0;
				self.lastTriggered = layerToShow;
			}
		}
			
	}; // end of object being returned
});
